namespace NorthwindClasses {
    using System;
    using System.ComponentModel;
    using System.Collections;
	using Borland.Eco.Services;
    using Borland.Eco.ObjectRepresentation;
    using Borland.Eco.ObjectImplementation;
    using Borland.Eco.UmlRt;
    using Borland.Eco.UmlCodeAttributes;
	[UmlElement("Package", Id="5205ff85-06a4-490f-9071-bd455d6de18d")]
	[UmlMetaAttribute("ownedElement", typeof(Category))]
	[UmlMetaAttribute("ownedElement", typeof(CustomerDemographic))]
	[UmlMetaAttribute("ownedElement", typeof(Customer))]
	[UmlMetaAttribute("ownedElement", typeof(Employee))]
	[UmlMetaAttribute("ownedElement", typeof(OrderDetail))]
	[UmlMetaAttribute("ownedElement", typeof(Order))]
	[UmlMetaAttribute("ownedElement", typeof(Product))]
	[UmlMetaAttribute("ownedElement", typeof(Region))]
	[UmlMetaAttribute("ownedElement", typeof(Shipper))]
	[UmlMetaAttribute("ownedElement", typeof(Supplier))]
	[UmlMetaAttribute("ownedElement", typeof(Territory))]
	[EcoCodeGenVersion("2.0")]
    public class NorthwindClassesPackage {

        [UmlElement("Association", Id="2b77ca11-ba05-44c7-92e0-b4dc2484825a")]
		public class Category_Products
		{
		}

        [UmlElement("Association", Id="9281a891-c613-44bc-bc46-e5e989c31759")]
		public class CustomerDemographics_Customers
		{
		}

        [UmlElement("Association", Id="3cd35907-17ac-4ddb-a159-780ad4a87ee4")]
		public class Customer_Orders
		{
		}

        [UmlElement("Association", Id="9b1425f8-0398-4e43-9a56-5e4c3dccf08e")]
		public class Employees_ReportsTo
		{
		}

        [UmlElement("Association", Id="2cc1699e-9a18-4504-880c-11be80da27ed")]
		public class Employees_Territories
		{
		}

        [UmlElement("Association", Id="a9db7074-5ae8-4cb0-922f-5512a8696504")]
		public class Employee_Orders
		{
		}

        [UmlElement("Association", Id="fc4ee4d4-eb87-4349-9a51-42f44b4d5adf")]
		public class Order_OrderDetails
		{
		}

        [UmlElement("Association", Id="56e51fcc-7548-4670-8cb0-3dd20c5c2b0d")]
		public class OrderDetails_Product
		{
		}

        [UmlElement("Association", Id="f05cd9e3-24fe-4599-8b2b-e3bd30c03db2")]
		public class Orders_ShipVia
		{
		}

        [UmlElement("Association", Id="89779818-3ecd-4d72-b08d-f3c2cd67a0ea")]
		public class Products_Supplier
		{
		}

        [UmlElement("Association", Id="9c64ea82-1575-43a1-a428-0da2d5602534")]
		public class Region_Territories
		{
		}
    }
    [UmlElement(Id="254d7720-435f-4adb-8759-076ae94f16ef")]
    public class Category : ILoopBack {

        public class CategoryListAdapter : ObjectListAdapter, ICategoryList
		{
			public CategoryListAdapter(IList source) : 
					base(source)
			{
			}
			public Category this[int index]
			{
				get
				{
					return ((Category)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Category value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Category value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Category value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Category value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Category value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Category(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 5);
			public const int Description = Eco_FirstMember;
			public const int Picture = (Description + 1);
			public const int Id = (Picture + 1);
			public const int CategoryName = (Id + 1);
			public const int Products = (CategoryName + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Category(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
        [UmlElement(Id="ee81a890-f31e-40bc-abf1-952ecbb31b08", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "DbAssign")]
		public int Id
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}

        [UmlElement(Id="fd175be2-ea7f-4f01-b03d-d0ec7854caf3", Index=Eco_LoopbackIndices.CategoryName)]
		public string CategoryName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.CategoryName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.CategoryName, ((object)(value)));
			}
		}

        [UmlElement(Id="0a280f5f-4787-4396-8cf0-c40a0c234b7f", Index=Eco_LoopbackIndices.Description)]
		public string Description
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Description)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Description, ((object)(value)));
			}
		}

        [UmlElement(Id="933a37fe-9412-48f8-b274-ecdf2b1e6535", Index=Eco_LoopbackIndices.Picture)]
		[UmlTaggedValue("Eco.DelayedFetch", "True")]
		public byte[] Picture
		{
			get
			{
				return ((byte[])(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Picture)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Picture, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Products, Id="f9060493-1331-4804-b1bb-4905c50d330e")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Category_Products), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IProductList Products
		{
			get
			{
				return new Product.ProductListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Products))));
			}
		}

    }

	[UmlCollection(typeof(Category))]
	public interface ICategoryList : ICollection
	{
		#region ECO generated code
		Category this[int index]
		{
			get;
			set;
		}
		int Add(Category value);
		bool Contains(Category value);
		int IndexOf(Category value);
		void Insert(int index, Category value);
		void Remove(Category value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="08f8d4ec-1e8a-4bfd-b6c7-74b142fe8ebf")]
    public class CustomerDemographic : ILoopBack {

        public class CustomerDemographicListAdapter : ObjectListAdapter, ICustomerDemographicList
		{
			public CustomerDemographicListAdapter(IList source) : 
					base(source)
			{
			}
			public CustomerDemographic this[int index]
			{
				get
				{
					return ((CustomerDemographic)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(CustomerDemographic value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(CustomerDemographic value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(CustomerDemographic value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, CustomerDemographic value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(CustomerDemographic value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public CustomerDemographic(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 3);
			public const int CustomerDesc = Eco_FirstMember;
			public const int Id = (CustomerDesc + 1);
			public const int Customers = (Id + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public CustomerDemographic(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
        [UmlElement(Id="fe86ef84-d68f-4f80-a03e-fd8620c9558a", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string Id
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Customers, Id="dcbd7c42-3257-4f6a-9e8f-edb18d4edc0b")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.CustomerDemographics_Customers), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public ICustomerList Customers
		{
			get
			{
				return new Customer.CustomerListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Customers))));
			}
		}

        [UmlElement(Id="f623b206-a764-45e6-98d5-67c8b4e9f657", Index=Eco_LoopbackIndices.CustomerDesc)]
		public string CustomerDesc
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.CustomerDesc)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.CustomerDesc, ((object)(value)));
			}
		}

    }

	[UmlCollection(typeof(CustomerDemographic))]
	public interface ICustomerDemographicList : ICollection
	{
		#region ECO generated code
		CustomerDemographic this[int index]
		{
			get;
			set;
		}
		int Add(CustomerDemographic value);
		bool Contains(CustomerDemographic value);
		int IndexOf(CustomerDemographic value);
		void Insert(int index, CustomerDemographic value);
		void Remove(CustomerDemographic value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="43057ac3-7032-4eed-af74-0dc540d48c71")]
    public class Customer : ILoopBack {

        public class CustomerListAdapter : ObjectListAdapter, ICustomerList
		{
			public CustomerListAdapter(IList source) : 
					base(source)
			{
			}
			public Customer this[int index]
			{
				get
				{
					return ((Customer)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Customer value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Customer value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Customer value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Customer value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Customer value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Customer(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 13);
			public const int PostalCode = Eco_FirstMember;
			public const int Region = (PostalCode + 1);
			public const int Country = (Region + 1);
			public const int Id = (Country + 1);
			public const int Address = (Id + 1);
			public const int ContactName = (Address + 1);
			public const int Fax = (ContactName + 1);
			public const int CompanyName = (Fax + 1);
			public const int ContactTitle = (CompanyName + 1);
			public const int Phone = (ContactTitle + 1);
			public const int City = (Phone + 1);
			public const int CustomerDemographics = (City + 1);
			public const int Orders = (CustomerDemographics + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Customer(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
        [UmlElement(Id="4374879f-2c4b-4fbc-abcc-8878dac1e1ea", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string Id
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.CustomerDemographics, Id="7668293e-abef-4dfe-98f5-1c92b51ecf5a")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.CustomerDemographics_Customers), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public ICustomerDemographicList CustomerDemographics
		{
			get
			{
				return new CustomerDemographic.CustomerDemographicListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.CustomerDemographics))));
			}
		}

        [UmlElement(Id="893a5e91-4cf6-4ea4-95fc-dcc8ba3c3773", Index=Eco_LoopbackIndices.CompanyName)]
		public string CompanyName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.CompanyName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.CompanyName, ((object)(value)));
			}
		}

        [UmlElement(Id="6dd0b22f-548f-4004-bea9-f4644108b318", Index=Eco_LoopbackIndices.ContactName)]
		public string ContactName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ContactName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ContactName, ((object)(value)));
			}
		}

        [UmlElement(Id="a35470d3-80ea-4231-a439-f731f79e7f69", Index=Eco_LoopbackIndices.ContactTitle)]
		public string ContactTitle
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ContactTitle)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ContactTitle, ((object)(value)));
			}
		}

        [UmlElement(Id="615810cf-f1c1-4d3a-8afb-f7dd02ca4ba2", Index=Eco_LoopbackIndices.Address)]
		public string Address
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Address)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Address, ((object)(value)));
			}
		}

        [UmlElement(Id="f6e8dbd4-dab4-4f03-a44d-7657f801bb10", Index=Eco_LoopbackIndices.City)]
		public string City
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.City)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.City, ((object)(value)));
			}
		}

        [UmlElement(Id="162200fc-fe72-47bc-b1ad-b3067cc7a762", Index=Eco_LoopbackIndices.Region)]
		public string Region
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Region)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Region, ((object)(value)));
			}
		}

        [UmlElement(Id="084bcb06-e257-478d-ab20-821e607cce64", Index=Eco_LoopbackIndices.PostalCode)]
		public string PostalCode
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.PostalCode)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.PostalCode, ((object)(value)));
			}
		}

        [UmlElement(Id="2171256d-ef9f-4dbf-8a94-9b90900b1359", Index=Eco_LoopbackIndices.Country)]
		public string Country
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Country)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Country, ((object)(value)));
			}
		}

        [UmlElement(Id="bd3e35fc-6239-41eb-a028-c5130384403a", Index=Eco_LoopbackIndices.Phone)]
		public string Phone
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Phone)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Phone, ((object)(value)));
			}
		}

        [UmlElement(Id="85261aed-f328-4ae1-8ac9-c67a95f400f5", Index=Eco_LoopbackIndices.Fax)]
		public string Fax
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Fax)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Fax, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Orders, Id="a6ccf760-7a9c-4e4c-ba92-73070feae500")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Customer_Orders), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IOrderList Orders
		{
			get
			{
				return new Order.OrderListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Orders))));
			}
		}

    }

	[UmlCollection(typeof(Customer))]
	public interface ICustomerList : ICollection
	{
		#region ECO generated code
		Customer this[int index]
		{
			get;
			set;
		}
		int Add(Customer value);
		bool Contains(Customer value);
		int IndexOf(Customer value);
		void Insert(int index, Customer value);
		void Remove(Customer value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="1909552a-e0e2-4d73-92f8-4df0a9520435")]
    public class Employee : ILoopBack {

        public class EmployeeListAdapter : ObjectListAdapter, IEmployeeList
		{
			public EmployeeListAdapter(IList source) : 
					base(source)
			{
			}
			public Employee this[int index]
			{
				get
				{
					return ((Employee)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Employee value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Employee value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Employee value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Employee value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Employee value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Employee(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 21);
			public const int TitleOfCourtesy = Eco_FirstMember;
			public const int Address = (TitleOfCourtesy + 1);
			public const int LastName = (Address + 1);
			public const int BirthDate = (LastName + 1);
			public const int FirstName = (BirthDate + 1);
			public const int Notes = (FirstName + 1);
			public const int HireDate = (Notes + 1);
			public const int City = (HireDate + 1);
			public const int PostalCode = (City + 1);
			public const int Extension = (PostalCode + 1);
			public const int PhotoPath = (Extension + 1);
			public const int Id = (PhotoPath + 1);
			public const int Region = (Id + 1);
			public const int Title = (Region + 1);
			public const int Photo = (Title + 1);
			public const int HomePhone = (Photo + 1);
			public const int Country = (HomePhone + 1);
			public const int Territories = (Country + 1);
			public const int Employees = (Territories + 1);
			public const int ReportsTo = (Employees + 1);
			public const int Orders = (ReportsTo + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Employee(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
        [UmlElement(Id="bb51cfbd-6bb8-4948-b7d7-f1b79a2fd7fd", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "DbAssign")]
		public int Id
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}

        [UmlElement(Id="1db6a7c7-82fc-41f3-a237-317384ca535d", Index=Eco_LoopbackIndices.LastName)]
		public string LastName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.LastName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.LastName, ((object)(value)));
			}
		}

        [UmlElement(Id="277aa68b-b664-46c5-a614-7245e5aefb3c", Index=Eco_LoopbackIndices.FirstName)]
		public string FirstName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.FirstName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.FirstName, ((object)(value)));
			}
		}

        [UmlElement(Id="d042c608-beb0-4a83-a7de-afe30947954b", Index=Eco_LoopbackIndices.Title)]
		public string Title
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Title)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Title, ((object)(value)));
			}
		}

        [UmlElement(Id="0f094e2a-7901-41a0-b318-2c1afa9f6411", Index=Eco_LoopbackIndices.TitleOfCourtesy)]
		public string TitleOfCourtesy
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.TitleOfCourtesy)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.TitleOfCourtesy, ((object)(value)));
			}
		}

        [UmlElement(Id="20ffd35f-aebc-4cf7-ac96-2f742b6997aa", Index=Eco_LoopbackIndices.BirthDate)]
		public DateTime BirthDate
		{
			get
			{
				return ((DateTime)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BirthDate)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BirthDate, ((object)(value)));
			}
		}

        [UmlElement(Id="7397110f-7f3a-4d1e-ba88-1b46b97553a2", Index=Eco_LoopbackIndices.HireDate)]
		public DateTime HireDate
		{
			get
			{
				return ((DateTime)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.HireDate)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.HireDate, ((object)(value)));
			}
		}

        [UmlElement(Id="11cee1a2-ee5c-4d50-a7f7-aab91b1088b5", Index=Eco_LoopbackIndices.Address)]
		public string Address
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Address)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Address, ((object)(value)));
			}
		}

        [UmlElement(Id="7b4ea762-d555-4d6c-b44a-0c1b17fa0cf4", Index=Eco_LoopbackIndices.City)]
		public string City
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.City)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.City, ((object)(value)));
			}
		}

        [UmlElement(Id="bc6b5068-906f-4e8d-893b-2850ae9e46b1", Index=Eco_LoopbackIndices.Region)]
		public string Region
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Region)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Region, ((object)(value)));
			}
		}

        [UmlElement(Id="7c688743-5ff6-452c-bf9b-2180b6ca3f78", Index=Eco_LoopbackIndices.PostalCode)]
		public string PostalCode
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.PostalCode)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.PostalCode, ((object)(value)));
			}
		}

        [UmlElement(Id="f7c63ae0-f5fe-4735-a2c4-6455444d7b6f", Index=Eco_LoopbackIndices.Country)]
		public string Country
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Country)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Country, ((object)(value)));
			}
		}

        [UmlElement(Id="d1c4b023-366f-48b7-a0bf-6807ff222c07", Index=Eco_LoopbackIndices.HomePhone)]
		public string HomePhone
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.HomePhone)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.HomePhone, ((object)(value)));
			}
		}

        [UmlElement(Id="7cb0eed4-09f9-49c5-b455-1bbf145e327c", Index=Eco_LoopbackIndices.Extension)]
		public string Extension
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Extension)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Extension, ((object)(value)));
			}
		}

        [UmlElement(Id="d0b35b6a-af2d-426d-9940-0e4a364d4c4d", Index=Eco_LoopbackIndices.Photo)]
		[UmlTaggedValue("Eco.DelayedFetch", "True")]
		public byte[] Photo
		{
			get
			{
				return ((byte[])(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Photo)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Photo, ((object)(value)));
			}
		}

        [UmlElement(Id="53f4bbcc-b90d-4bf6-8bd1-f7d50a08ae8c", Index=Eco_LoopbackIndices.Notes)]
		public string Notes
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Notes)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Notes, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.ReportsTo, Id="5aaa7f8e-7ae3-4b5e-a204-2ebf3749df25")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Employees_ReportsTo), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Employee ReportsTo
		{
			get
			{
				return ((Employee)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ReportsTo)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ReportsTo, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Employees, Id="5766eb34-6aaf-4798-8b7e-6ce2b1243a4f")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Employees_ReportsTo), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IEmployeeList Employees
		{
			get
			{
				return new Employee.EmployeeListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Employees))));
			}
		}

        [UmlElement(Id="873a7484-0e6b-4ee0-aa24-0a32d4af911b", Index=Eco_LoopbackIndices.PhotoPath)]
		public string PhotoPath
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.PhotoPath)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.PhotoPath, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Territories, Id="24a0bbad-0729-469b-ab9a-2ab7ae78f8ac")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Employees_Territories), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public ITerritoryList Territories
		{
			get
			{
				return new Territory.TerritoryListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Territories))));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Orders, Id="ebf9d68c-7627-40f5-8dea-849d12c06a90")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Employee_Orders), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IOrderList Orders
		{
			get
			{
				return new Order.OrderListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Orders))));
			}
		}

    }

	[UmlCollection(typeof(Employee))]
	public interface IEmployeeList : ICollection
	{
		#region ECO generated code
		Employee this[int index]
		{
			get;
			set;
		}
		int Add(Employee value);
		bool Contains(Employee value);
		int IndexOf(Employee value);
		void Insert(int index, Employee value);
		void Remove(Employee value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="effc8a6d-7f9d-4f5e-bbe7-ee64787180c8")]
    public class OrderDetail : ILoopBack {

        public class OrderDetailListAdapter : ObjectListAdapter, IOrderDetailList
		{
			public OrderDetailListAdapter(IList source) : 
					base(source)
			{
			}
			public OrderDetail this[int index]
			{
				get
				{
					return ((OrderDetail)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(OrderDetail value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(OrderDetail value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(OrderDetail value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, OrderDetail value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(OrderDetail value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public OrderDetail(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 5);
			public const int Discount = Eco_FirstMember;
			public const int UnitPrice = (Discount + 1);
			public const int Quantity = (UnitPrice + 1);
			public const int Product = (Quantity + 1);
			public const int Order = (Product + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public OrderDetail(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Order, Id="e5181c9b-cb13-4fa5-abfa-71e90885477b")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Order_OrderDetails), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Order Order
		{
			get
			{
				return ((Order)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Order)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Order, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Product, Id="66c5ca2d-5f76-4642-b6d0-49982777d27d")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.OrderDetails_Product), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Product Product
		{
			get
			{
				return ((Product)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Product)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Product, ((object)(value)));
			}
		}

        [UmlElement(Id="49a3dde2-9497-4f3d-aca3-b60b7eaa218a", Index=Eco_LoopbackIndices.UnitPrice)]
		public decimal UnitPrice
		{
			get
			{
				return ((decimal)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.UnitPrice)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.UnitPrice, ((object)(value)));
			}
		}

        [UmlElement(Id="d32550e1-e708-4810-a89b-684b944ee6b3", Index=Eco_LoopbackIndices.Quantity)]
		public short Quantity
		{
			get
			{
				return ((short)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Quantity)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Quantity, ((object)(value)));
			}
		}

        [UmlElement(Id="1840e3be-3c78-4620-b96a-3ab057e21eee", Index=Eco_LoopbackIndices.Discount)]
		public float Discount
		{
			get
			{
				return ((float)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Discount)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Discount, ((object)(value)));
			}
		}

    }

	[UmlCollection(typeof(OrderDetail))]
	public interface IOrderDetailList : ICollection
	{
		#region ECO generated code
		OrderDetail this[int index]
		{
			get;
			set;
		}
		int Add(OrderDetail value);
		bool Contains(OrderDetail value);
		int IndexOf(OrderDetail value);
		void Insert(int index, OrderDetail value);
		void Remove(OrderDetail value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="e86041d6-f86d-4df5-9458-f215a678ace7")]
    public class Order : ILoopBack {

        public class OrderListAdapter : ObjectListAdapter, IOrderList
		{
			public OrderListAdapter(IList source) : 
					base(source)
			{
			}
			public Order this[int index]
			{
				get
				{
					return ((Order)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Order value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Order value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Order value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Order value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Order value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Order(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 15);
			public const int ShippedDate = Eco_FirstMember;
			public const int OrderDate = (ShippedDate + 1);
			public const int ShipPostalCode = (OrderDate + 1);
			public const int ShipName = (ShipPostalCode + 1);
			public const int RequiredDate = (ShipName + 1);
			public const int Freight = (RequiredDate + 1);
			public const int ShipCity = (Freight + 1);
			public const int Id = (ShipCity + 1);
			public const int ShipCountry = (Id + 1);
			public const int ShipAddress = (ShipCountry + 1);
			public const int ShipRegion = (ShipAddress + 1);
			public const int ShipVia = (ShipRegion + 1);
			public const int Customer = (ShipVia + 1);
			public const int Employee = (Customer + 1);
			public const int OrderDetails = (Employee + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Order(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
        [UmlElement(Id="d1ab3b6f-4533-46c6-b41b-44c3d5b87539", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "DbAssign")]
		public int Id
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.OrderDetails, Id="b90204a6-7f67-4f5a-b0b7-5183107c6eed")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Order_OrderDetails), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IOrderDetailList OrderDetails
		{
			get
			{
				return new OrderDetail.OrderDetailListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.OrderDetails))));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Customer, Id="a40fc65c-efe3-46a4-ad39-07e9d827c203")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Customer_Orders), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Customer Customer
		{
			get
			{
				return ((Customer)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Customer)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Customer, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Employee, Id="b1268f44-1cea-498d-a458-c72daf065d37")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Employee_Orders), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Employee Employee
		{
			get
			{
				return ((Employee)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Employee)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Employee, ((object)(value)));
			}
		}

        [UmlElement(Id="1e483d68-92f5-4c9c-9df9-1779820759d6", Index=Eco_LoopbackIndices.OrderDate)]
		public DateTime OrderDate
		{
			get
			{
				return ((DateTime)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.OrderDate)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.OrderDate, ((object)(value)));
			}
		}

        [UmlElement(Id="b5b02c17-332e-4166-8a52-b70fc2026637", Index=Eco_LoopbackIndices.RequiredDate)]
		public DateTime RequiredDate
		{
			get
			{
				return ((DateTime)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.RequiredDate)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.RequiredDate, ((object)(value)));
			}
		}

        [UmlElement(Id="10673acc-3ea4-435e-bfd3-44243e1bc6cb", Index=Eco_LoopbackIndices.ShippedDate)]
		public DateTime ShippedDate
		{
			get
			{
				return ((DateTime)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShippedDate)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShippedDate, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.ShipVia, Id="59d01861-0f1a-4f81-8191-c85fd60b36de")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Orders_ShipVia), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Shipper ShipVia
		{
			get
			{
				return ((Shipper)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipVia)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipVia, ((object)(value)));
			}
		}

        [UmlElement(Id="bec60f41-5a7b-4470-8593-0bfeb888d435", Index=Eco_LoopbackIndices.Freight)]
		public decimal Freight
		{
			get
			{
				return ((decimal)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Freight)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Freight, ((object)(value)));
			}
		}

        [UmlElement(Id="3cfe80a3-0bdf-4899-8845-12e7c866d76d", Index=Eco_LoopbackIndices.ShipName)]
		public string ShipName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipName, ((object)(value)));
			}
		}

        [UmlElement(Id="d9618e1c-9573-4c2b-a790-f33565a6ae04", Index=Eco_LoopbackIndices.ShipAddress)]
		public string ShipAddress
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipAddress)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipAddress, ((object)(value)));
			}
		}

        [UmlElement(Id="ca07d186-62ec-4e3f-9185-12e9ad355feb", Index=Eco_LoopbackIndices.ShipCity)]
		public string ShipCity
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipCity)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipCity, ((object)(value)));
			}
		}

        [UmlElement(Id="e39e060e-5662-47d4-bb30-8be88970f76d", Index=Eco_LoopbackIndices.ShipRegion)]
		public string ShipRegion
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipRegion)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipRegion, ((object)(value)));
			}
		}

        [UmlElement(Id="2e8f5434-d65b-4d08-8f40-cd64f9c6a54f", Index=Eco_LoopbackIndices.ShipPostalCode)]
		public string ShipPostalCode
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipPostalCode)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipPostalCode, ((object)(value)));
			}
		}

        [UmlElement(Id="d4c2ad44-2dbc-4d70-acf5-e120cc6ad085", Index=Eco_LoopbackIndices.ShipCountry)]
		public string ShipCountry
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipCountry)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipCountry, ((object)(value)));
			}
		}

    }

	[UmlCollection(typeof(Order))]
	public interface IOrderList : ICollection
	{
		#region ECO generated code
		Order this[int index]
		{
			get;
			set;
		}
		int Add(Order value);
		bool Contains(Order value);
		int IndexOf(Order value);
		void Insert(int index, Order value);
		void Remove(Order value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="67c17c34-c7f0-4d12-8219-fa52b6a158d7")]
    public class Product : ILoopBack {

        public class ProductListAdapter : ObjectListAdapter, IProductList
		{
			public ProductListAdapter(IList source) : 
					base(source)
			{
			}
			public Product this[int index]
			{
				get
				{
					return ((Product)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Product value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Product value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Product value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Product value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Product value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Product(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 11);
			public const int UnitsOnOrder = Eco_FirstMember;
			public const int UnitPrice = (UnitsOnOrder + 1);
			public const int ReorderLevel = (UnitPrice + 1);
			public const int UnitsInStock = (ReorderLevel + 1);
			public const int QuantityPerUnit = (UnitsInStock + 1);
			public const int Id = (QuantityPerUnit + 1);
			public const int Discontinued = (Id + 1);
			public const int ProductName = (Discontinued + 1);
			public const int OrderDetails = (ProductName + 1);
			public const int Supplier = (OrderDetails + 1);
			public const int Category = (Supplier + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Product(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
        [UmlElement(Id="8f6d83f9-3f70-4105-a1e7-e3c7eba8d1a8", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "DbAssign")]
		public int Id
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.OrderDetails, Id="1d815671-3154-4244-be75-903a6bbc974f")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.OrderDetails_Product), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IOrderDetailList OrderDetails
		{
			get
			{
				return new OrderDetail.OrderDetailListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.OrderDetails))));
			}
		}

        [UmlElement(Id="c139cf3d-e2bb-4fdf-9010-563d636c0dfa", Index=Eco_LoopbackIndices.ProductName)]
		public string ProductName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ProductName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ProductName, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Supplier, Id="a45d8ba7-6146-4f30-846a-6cc256d4b455")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Products_Supplier), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Supplier Supplier
		{
			get
			{
				return ((Supplier)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Supplier)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Supplier, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Category, Id="ca771204-ee68-45c8-997e-f5f0f4478961")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Category_Products), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Category Category
		{
			get
			{
				return ((Category)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Category)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Category, ((object)(value)));
			}
		}

        [UmlElement(Id="79f578c6-0f4e-4316-8d63-2b1f9459cfe1", Index=Eco_LoopbackIndices.QuantityPerUnit)]
		public string QuantityPerUnit
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.QuantityPerUnit)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.QuantityPerUnit, ((object)(value)));
			}
		}

        [UmlElement(Id="136bce5d-a92e-4daa-bc40-4dd12401c5d3", Index=Eco_LoopbackIndices.UnitPrice)]
		public decimal UnitPrice
		{
			get
			{
				return ((decimal)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.UnitPrice)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.UnitPrice, ((object)(value)));
			}
		}

        [UmlElement(Id="760f21f8-0170-4474-95d8-34730829fd06", Index=Eco_LoopbackIndices.UnitsInStock)]
		public short UnitsInStock
		{
			get
			{
				return ((short)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.UnitsInStock)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.UnitsInStock, ((object)(value)));
			}
		}

        [UmlElement(Id="01205cbc-4d39-4c8d-84ef-b22120fabe86", Index=Eco_LoopbackIndices.UnitsOnOrder)]
		public short UnitsOnOrder
		{
			get
			{
				return ((short)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.UnitsOnOrder)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.UnitsOnOrder, ((object)(value)));
			}
		}

        [UmlElement(Id="3eceed5c-37d9-45d3-8c0d-b54f991b6b1b", Index=Eco_LoopbackIndices.ReorderLevel)]
		public short ReorderLevel
		{
			get
			{
				return ((short)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ReorderLevel)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ReorderLevel, ((object)(value)));
			}
		}

        [UmlElement(Id="b996bde2-d5ff-4e8b-af9a-74d431da6482", Index=Eco_LoopbackIndices.Discontinued)]
		public bool Discontinued
		{
			get
			{
				return ((bool)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Discontinued)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Discontinued, ((object)(value)));
			}
		}

    }

	[UmlCollection(typeof(Product))]
	public interface IProductList : ICollection
	{
		#region ECO generated code
		Product this[int index]
		{
			get;
			set;
		}
		int Add(Product value);
		bool Contains(Product value);
		int IndexOf(Product value);
		void Insert(int index, Product value);
		void Remove(Product value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="2933740b-e91e-41ec-85f2-ad03087ea821")]
    public class Region : ILoopBack {

        public class RegionListAdapter : ObjectListAdapter, IRegionList
		{
			public RegionListAdapter(IList source) : 
					base(source)
			{
			}
			public Region this[int index]
			{
				get
				{
					return ((Region)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Region value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Region value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Region value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Region value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Region value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Region(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 3);
			public const int Id = Eco_FirstMember;
			public const int RegionDescription = (Id + 1);
			public const int Territories = (RegionDescription + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Region(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
        [UmlElement(Id="1081dc72-4280-40a4-8ebb-aedc154cd8ab", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public int Id
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}

        [UmlElement(Id="5db82720-bb1c-4567-a724-b95145e9ab34", Index=Eco_LoopbackIndices.RegionDescription)]
		public string RegionDescription
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.RegionDescription)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.RegionDescription, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Territories, Id="b3646e58-6962-4f0e-883d-f84401cbdf88")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Region_Territories), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public ITerritoryList Territories
		{
			get
			{
				return new Territory.TerritoryListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Territories))));
			}
		}

    }

	[UmlCollection(typeof(Region))]
	public interface IRegionList : ICollection
	{
		#region ECO generated code
		Region this[int index]
		{
			get;
			set;
		}
		int Add(Region value);
		bool Contains(Region value);
		int IndexOf(Region value);
		void Insert(int index, Region value);
		void Remove(Region value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="69c8fa73-ff92-4a06-8143-31f6afdffef9")]
    public class Shipper : ILoopBack {

        public class ShipperListAdapter : ObjectListAdapter, IShipperList
		{
			public ShipperListAdapter(IList source) : 
					base(source)
			{
			}
			public Shipper this[int index]
			{
				get
				{
					return ((Shipper)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Shipper value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Shipper value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Shipper value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Shipper value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Shipper value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Shipper(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 4);
			public const int Phone = Eco_FirstMember;
			public const int CompanyName = (Phone + 1);
			public const int Id = (CompanyName + 1);
			public const int Orders = (Id + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Shipper(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
        [UmlElement(Id="e619e488-76c8-40b0-bb83-e2d022f829ae", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "DbAssign")]
		public int Id
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Orders, Id="84e0f5e2-f2b0-4303-9d77-40b1cbda9f59")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Orders_ShipVia), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IOrderList Orders
		{
			get
			{
				return new Order.OrderListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Orders))));
			}
		}

        [UmlElement(Id="3d4a3319-c20f-4800-818d-8f1387cccd02", Index=Eco_LoopbackIndices.CompanyName)]
		public string CompanyName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.CompanyName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.CompanyName, ((object)(value)));
			}
		}

        [UmlElement(Id="000dab86-89e2-4428-a314-a18fbdd98bc9", Index=Eco_LoopbackIndices.Phone)]
		public string Phone
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Phone)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Phone, ((object)(value)));
			}
		}

    }

	[UmlCollection(typeof(Shipper))]
	public interface IShipperList : ICollection
	{
		#region ECO generated code
		Shipper this[int index]
		{
			get;
			set;
		}
		int Add(Shipper value);
		bool Contains(Shipper value);
		int IndexOf(Shipper value);
		void Insert(int index, Shipper value);
		void Remove(Shipper value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="56147375-b8cb-472a-90c7-7e63d8079c81")]
    public class Supplier : ILoopBack {

        public class SupplierListAdapter : ObjectListAdapter, ISupplierList
		{
			public SupplierListAdapter(IList source) : 
					base(source)
			{
			}
			public Supplier this[int index]
			{
				get
				{
					return ((Supplier)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Supplier value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Supplier value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Supplier value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Supplier value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Supplier value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Supplier(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 13);
			public const int PostalCode = Eco_FirstMember;
			public const int Address = (PostalCode + 1);
			public const int Country = (Address + 1);
			public const int ContactTitle = (Country + 1);
			public const int CompanyName = (ContactTitle + 1);
			public const int HomePage = (CompanyName + 1);
			public const int Region = (HomePage + 1);
			public const int ContactName = (Region + 1);
			public const int Fax = (ContactName + 1);
			public const int City = (Fax + 1);
			public const int Id = (City + 1);
			public const int Phone = (Id + 1);
			public const int Products = (Phone + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Supplier(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
        [UmlElement(Id="d24d2bce-c4ce-45c3-b03a-8a53913a49ea", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "DbAssign")]
		public int Id
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Products, Id="ec7b8e05-25da-4400-a794-7a2b7c9f6e7d")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Products_Supplier), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IProductList Products
		{
			get
			{
				return new Product.ProductListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Products))));
			}
		}

        [UmlElement(Id="3d0842dd-dbd3-46c5-ad37-dd4249b70f1d", Index=Eco_LoopbackIndices.CompanyName)]
		public string CompanyName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.CompanyName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.CompanyName, ((object)(value)));
			}
		}

        [UmlElement(Id="794f0101-9b06-4c92-ba87-37d9782e61f1", Index=Eco_LoopbackIndices.ContactName)]
		public string ContactName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ContactName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ContactName, ((object)(value)));
			}
		}

        [UmlElement(Id="2e4ac5a5-d172-4674-979e-809519bf77f5", Index=Eco_LoopbackIndices.ContactTitle)]
		public string ContactTitle
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ContactTitle)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ContactTitle, ((object)(value)));
			}
		}

        [UmlElement(Id="116fb508-0687-4686-9d5f-3ddefaf88f68", Index=Eco_LoopbackIndices.Address)]
		public string Address
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Address)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Address, ((object)(value)));
			}
		}

        [UmlElement(Id="bdc11d1c-d7d5-481a-af8a-89ec49f679d1", Index=Eco_LoopbackIndices.City)]
		public string City
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.City)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.City, ((object)(value)));
			}
		}

        [UmlElement(Id="666b0486-cc6d-49fd-a87a-b1376e700b0e", Index=Eco_LoopbackIndices.Region)]
		public string Region
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Region)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Region, ((object)(value)));
			}
		}

        [UmlElement(Id="02115b2f-a5ff-453d-a0bb-09fd6984b795", Index=Eco_LoopbackIndices.PostalCode)]
		public string PostalCode
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.PostalCode)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.PostalCode, ((object)(value)));
			}
		}

        [UmlElement(Id="1e93bf6c-1ea4-403c-a708-33a85a8c6d1f", Index=Eco_LoopbackIndices.Country)]
		public string Country
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Country)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Country, ((object)(value)));
			}
		}

        [UmlElement(Id="ea28c554-8994-4fcd-ae5a-d32fd2851ba8", Index=Eco_LoopbackIndices.Phone)]
		public string Phone
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Phone)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Phone, ((object)(value)));
			}
		}

        [UmlElement(Id="7fc5af61-2b78-4dd0-bd8f-5590ecc3352a", Index=Eco_LoopbackIndices.Fax)]
		public string Fax
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Fax)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Fax, ((object)(value)));
			}
		}

        [UmlElement(Id="51ef592b-1c10-4ab9-b144-37dd2948ea49", Index=Eco_LoopbackIndices.HomePage)]
		public string HomePage
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.HomePage)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.HomePage, ((object)(value)));
			}
		}

    }

	[UmlCollection(typeof(Supplier))]
	public interface ISupplierList : ICollection
	{
		#region ECO generated code
		Supplier this[int index]
		{
			get;
			set;
		}
		int Add(Supplier value);
		bool Contains(Supplier value);
		int IndexOf(Supplier value);
		void Insert(int index, Supplier value);
		void Remove(Supplier value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="dbcc5525-513d-48f6-afa8-db98c3d103dd")]
    public class Territory : ILoopBack {

        public class TerritoryListAdapter : ObjectListAdapter, ITerritoryList
		{
			public TerritoryListAdapter(IList source) : 
					base(source)
			{
			}
			public Territory this[int index]
			{
				get
				{
					return ((Territory)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Territory value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Territory value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Territory value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Territory value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Territory value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Territory(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 4);
			public const int Id = Eco_FirstMember;
			public const int TerritoryDescription = (Id + 1);
			public const int Employees = (TerritoryDescription + 1);
			public const int Region = (Employees + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Territory(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
        [UmlElement(Id="04f2e554-64b5-4e70-84d8-425626c539c3", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string Id
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Employees, Id="4f0409ff-0b30-479a-b516-a36f4c744c0a")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Employees_Territories), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IEmployeeList Employees
		{
			get
			{
				return new Employee.EmployeeListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Employees))));
			}
		}

        [UmlElement(Id="3400de26-46cd-45f3-a7af-42ff8381b916", Index=Eco_LoopbackIndices.TerritoryDescription)]
		public string TerritoryDescription
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.TerritoryDescription)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.TerritoryDescription, ((object)(value)));
			}
		}

        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Region, Id="f5928696-7657-4e50-bc72-00dc9d39ceff")]
		[UmlMetaAttribute("association", typeof(NorthwindClassesPackage.Region_Territories), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Region Region
		{
			get
			{
				return ((Region)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Region)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Region, ((object)(value)));
			}
		}

    }

	[UmlCollection(typeof(Territory))]
	public interface ITerritoryList : ICollection
	{
		#region ECO generated code
		Territory this[int index]
		{
			get;
			set;
		}
		int Add(Territory value);
		bool Contains(Territory value);
		int IndexOf(Territory value);
		void Insert(int index, Territory value);
		void Remove(Territory value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
}
